(function () {
  const nav = document.getElementById('site-navigation');
  if (!nav) {
    return;
  }

  const toggle = document.getElementById('menu-toggle');
  if (!toggle) {
    return;
  }

  // tenta #primary-menu; se não achar, pega o primeiro UL dentro do nav
  let menu = nav.querySelector('#primary-menu');
  if (!menu) {
    menu = nav.querySelector('ul');
  }
  if (!menu) {
    return;
  }

  toggle.setAttribute('aria-expanded', 'false');

  function setOpen(open) {
    console.log('setOpen', open, typeof open);
    // const isOpen = !!open;
    nav.classList.toggle('toggled', open);
    toggle.setAttribute('aria-expanded', String(open));

    if (open) {
      menu.style.display = 'flex';
    } else {
      menu.style.display = '';
    }
  }

  function isOpen() {
    console.log('checkIsOpen', toggle.getAttribute('aria-expanded'), typeof toggle.getAttribute('aria-expanded'));
    return toggle.getAttribute('aria-expanded') === 'true';
  }

  function toggleMenu() {
    setOpen(!isOpen());
  }

  toggle.addEventListener('click', (e) => {
    console.log('click event triggered');
    e.preventDefault();
    toggleMenu();
  });

  document.addEventListener('keydown', (e) => {
    if (e.key === 'Escape' && nav.classList.contains('toggled')) {
      setOpen(false);
      toggle.focus();
    }
  });

  document.addEventListener('click', (e) => {
    if (!nav.classList.contains('toggled')) return;
    if (nav.contains(e.target)) return;
    setOpen(false);
  });
})();